//
//  RVTimeCode.h
//  CommunicationModule
//
//  Created by Greg Harris on 8/10/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface RVTimeCode : NSObject {
	NSUInteger frames, seconds, minutes, hours;
	BOOL dropFrameFlag, negativeFlag;
	CGFloat frameRate;
}

+ (RVTimeCode *) zeroTime;
+ (RVTimeCode *) timecodeWithFrames:(NSUInteger)f seconds:(NSUInteger)s minutes:(NSUInteger)m hours:(NSUInteger)h;
+ (RVTimeCode *) timecodeWithTimeValue:(NSUInteger)timeValue timeScale:(NSUInteger)timeScale frameRate:(float)frameRate;

- (NSString *) stringValue;

- (void) setFrames:(NSUInteger)f;
- (void) setSeconds:(NSUInteger)s;
- (void) setMinutes:(NSUInteger)m;
- (void) setHours:(NSUInteger)h;

- (void) setFramerate:(CGFloat)fr;

- (NSUInteger) frames;
- (NSUInteger) seconds;
- (NSUInteger) minutes;
- (NSUInteger) hours;

- (UInt64) totalFrames;

- (CGFloat) framerate;

@end

